package com.ho.crypto.test3.encryption.base64;

import java.io.IOException;

public class Base64ConversionTest {

	public static void main(String[] args) {
		try {
			String str = "123456ds fds #&er er "+System.getProperty("line.separator")+" ^rrr 7897ezrz";
			//
			{
				System.out.println("-------- Use of sun.misc.BASE64Decoder and sun.misc.BASE64Encoder ");
				System.out.println("Original=" + str);
				String strEnc = sun_misc_base64Encode(str.getBytes());
				System.out.println("Encoded=" + strEnc);
				String strDec = new String(sun_misc_base64Decode(strEnc));
				System.out.println("Decoded=" + strDec);
				System.out.println("Decoded is equal to Original=" + (strDec.equals(str)));
			}
			{
				System.out.println("-------- Use of org.apache.commons.codec.binary.Base64 (commons-codec-X.Y.jar) ");
				System.out.println("Original=" + str);
				String strEnc = apache_commons_codec_base64Encode(str.getBytes());
				System.out.println("Encoded=" + strEnc);
				String strDec = new String(apache_commons_codec_base64Decode(strEnc));
				System.out.println("Decoded=" + strDec);
				System.out.println("Decoded is equal to Original=" + (strDec.equals(str)));
			}
			{
				System.out.println("-------- Use of sun.misc.BASE64Decoder and sun.misc.BASE64Encoder and org.apache.commons.codec.binary.Base64 (commons-codec-X.Y.jar) ");
				System.out.println("Original=" + str);
				String strEnc = sun_misc_base64Encode(str.getBytes());
				System.out.println("Encoded=" + strEnc);
				String strDec = new String(apache_commons_codec_base64Decode(strEnc));
				System.out.println("Decoded=" + strDec);
				System.out.println("Decoded is equal to Original=" + (strDec.equals(str)));
			}

			
		} catch (Exception ex) {
			ex.printStackTrace();
		}
	}

	/**
	 * Use of sun.misc.BASE64Decoder and sun.misc.BASE64Encoder
	 */
	private static String sun_misc_base64Encode(byte[] bytes) {
		return new sun.misc.BASE64Encoder().encode(bytes);
	}
	private static byte[] sun_misc_base64Decode(String property) throws IOException {
		return new sun.misc.BASE64Decoder().decodeBuffer(property);
	}
	
	/**
	 * Use of org.apache.commons.codec.binary.Base64 (commons-codec-X.Y.jar)
	 */
	private static String apache_commons_codec_base64Encode(byte[] bytes) {
		return new String(new org.apache.commons.codec.binary.Base64().encode(bytes));
	}
	private static byte[] apache_commons_codec_base64Decode(String property) throws IOException {
		return new org.apache.commons.codec.binary.Base64().decode(property.getBytes());
	}

}
