package com.ho.crypto.test3.encryption.base64;

import java.io.IOException;

import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

/**
 * RFC-4648
 */
public final class Base64Url {
    
    private Base64Url() {
        super();
    }

	public static String encode(final byte[] content) {
		final String base64string = new BASE64Encoder().encode(content);
		
		System.out.println("Before base64url : " + base64string);
		
		String base64urlString = base64string.replace('+', '-'); // 62nd char of encoding
		base64urlString = base64urlString.replace('/', '_');	 // 63rd char of encoding
		
		while (base64urlString.endsWith("=")) { // Remove any trailing '='s
			base64urlString = base64urlString.substring(0, base64urlString.length() -1);
		}

		System.out.println("After base64url : " + base64urlString);

		return base64urlString;
	}
	
	public static byte[] decode(final String content) throws IOException {
		String base64string = content.replace('-', '+'); // 62nd char of encoding
		base64string = base64string.replace('_', '/');	 // 63rd char of encoding
		
		if (base64string.length() % 4 == 2) {
			base64string += "==";
		} else if (base64string.length() % 4 == 3) {
			base64string += "=";
		}

		System.out.println("Before base64 decode : " + base64string);

		return new BASE64Decoder().decodeBuffer(base64string);
	}
	
}
