package com.ho.crypto.test3.encryption.aes;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;

import javax.crypto.spec.IvParameterSpec;

/**
 * Class Test of EncryptionAesCbcPkcs5Padding
 * @author Huseyin OZVEREN
 */
public class EncryptionAesCbcPkcs5PaddingTest {

	public static void main(String[] args) {
		try{
			IvParameterSpec iv = EncryptionAesCbcPkcs5Padding.generateIV();
			byte[] keyValue = EncryptionAesCbcPkcs5Padding.generateSecretKey(EncryptionAesCbcPkcs5Padding.INTERNAL_KEY_GENERATION_MODE.GENERATED_WRAPPED_KEY);
	        aEncryptFile(keyValue, iv);
	        bDecryptFile(keyValue, iv);
		}catch(Throwable th){
			th.printStackTrace();
		}
    }

	/**
	 * Encrypt PDF file
	 * @param iv : Initialization vector
	 * @throws Exception
	 */
    public static void aEncryptFile(byte[] keyValue, IvParameterSpec iv) throws Exception {
        try {
            File sourceFile = new File(System.getProperty("user.dir") + "/resources/pdf_with_text.pdf");
            byte[] content = Files.readAllBytes(sourceFile.toPath());
            byte[] encryptContent = EncryptionAesCbcPkcs5Padding.encrypt(keyValue, iv, content);
            File targetFile = new File(System.getProperty("user.dir") + "/resources/pdf_with_text_encrypted_aes_cbc.pdf");
            if(targetFile.exists()){
            	targetFile.delete();
            }
            Files.write(targetFile.toPath(), encryptContent, StandardOpenOption.CREATE_NEW);
        } catch (Exception e) {
        	e.printStackTrace();
        }
    }

    
    /**
	 * Decrypt PDF file
	 * @param keyValue : secret key
	 * @param iv : Initialization vector
     * @throws Exception
     */
    public static void bDecryptFile(byte[] keyValue, IvParameterSpec iv) throws Exception {
        try {
            byte[] encryptContent = Files.readAllBytes(new File(System.getProperty("user.dir") + "/resources/pdf_with_text_encrypted_aes_cbc.pdf").toPath());
            byte[] decryptContent = EncryptionAesCbcPkcs5Padding.decrypt(keyValue, iv, encryptContent);
            File targetFile = new File(System.getProperty("user.dir") + "/resources/pdf_with_text_decrypted_aes_cbc.pdf");
            if(targetFile.exists()){
            	targetFile.delete();
            }
            Files.write(targetFile.toPath(), decryptContent, StandardOpenOption.CREATE_NEW);
        } catch (Exception e) {
        	e.printStackTrace();
        }

    }
}
