package com.ho.crypto.test3.encryption.blowfish;


import java.io.IOException;

import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

import com.ho.crypto.test3.encryption.base64.Base64Url;

/**
 * Anonymization of data via the algorithme Blowfish and Base64:
 * + Encryption : Blowfish AND [Base64 and replacing of '+' by '-', '/' by '_' and removing the '=' at the end]
 * + Decryption : [Base64 and replacing of '-' by '+', '_' by '/' and adding at the end a '='] AND Blowfish 
 * 
 * @author Huseyin OZVEREN
 *
 */
public class AnonymizationBlowfishBase64 {

	public static String cipher(final String input, final String secretKey) throws Exception {
        try {
        	System.out.println("Input length : " + input.getBytes().length + " bytes");
        	
        	SecretKeySpec secretKeySpec = new SecretKeySpec(secretKey.getBytes(), "Blowfish");
            Cipher cipher = Cipher.getInstance("Blowfish");
            cipher.init(Cipher.ENCRYPT_MODE, secretKeySpec);
            byte[] cipheredBytes = cipher.doFinal(input.getBytes());
            
            System.out.println("Blowfish result length : " + cipheredBytes.length + " bytes");
            
            String base64result = toBase64url(cipheredBytes);
            
            System.out.println("Base64 result length : " + base64result.getBytes().length + " bytes");
            
            return base64result;
        } catch (Exception e) {
        	throw new RuntimeException("Cannot cipher text", e);
        }
	}
	
	public static String decipher(final String input, final String secretKey) throws Exception {
		try {
        	byte[] cipheredBytes = fromBase64url(input);
        	
        	SecretKeySpec secretKeySpec = new SecretKeySpec(secretKey.getBytes(), "Blowfish");
            Cipher cipher = Cipher.getInstance("Blowfish");
            cipher.init(Cipher.DECRYPT_MODE, secretKeySpec);
            byte[] decipheredBytes = cipher.doFinal(cipheredBytes);
            
            return new String(decipheredBytes);
        } catch (Exception e) {
        	throw new Exception("Cannot cipher text", e);
        }
	}
	
	/**
	 * RFC-4648
	 * @param input
	 * @return
	 */
	private static String toBase64url(final byte[] input) {
		return Base64Url.encode(input);
	}
	
	/**
	 * RFC-4648
	 * @param base64urlString
	 * @return
	 */
	private static byte[] fromBase64url(final String base64urlString) throws IOException {
		return Base64Url.decode(base64urlString);
	}
	
}