package com.ho.crypto.test3.encryption.rsa;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;



/**
 * Class Test of EncryptionRsaEcbPkcs1Padding
 * @author Huseyin OZVEREN
 */
public class EncryptionRsaEcbPkcs1PaddingTest {
	
	public static void main(String[] args) {
		try{
			testWithKeysPair();
			System.out.println("-------------------------");
			testWithByteValueOfKeys();
			System.out.println("-------------------------");
			testWithModulosExponentOfKeys();
			System.out.println("-------------------------");
		}catch(Throwable th){
			th.printStackTrace();
		}
    }

	
	public static void testWithKeysPair() throws Throwable {
		//Generation of keys
		Pair<PublicKey,PrivateKey> keysValue = EncryptionRsaEcbPkcs1Padding.generateKeyPair();
		PublicKey publicKey = keysValue.getFirst();
		System.out.println("Public key =" + ((sun.security.rsa.RSAPublicKeyImpl)publicKey));
		PrivateKey privateKey = keysValue.getSecond();
		System.out.println("Private key =" + ((sun.security.rsa.RSAPrivateCrtKeyImpl)privateKey));

		// Data
		String sourceData = "123456ds fds #&er er "+System.getProperty("line.separator")+" ^rrr 7897ezrz";
		System.out.println("Original=" + sourceData);

		// Encrypt data
		byte[] encryptData = EncryptionRsaEcbPkcs1Padding.encrypt(publicKey, sourceData.getBytes());
		System.out.println("Encoded=" + new String(encryptData));
		
		// Decrypt data
    	byte[] decryptData = EncryptionRsaEcbPkcs1Padding.decrypt(privateKey, encryptData);
    	String finalData = (decryptData!=null)? new String(decryptData):"";
		System.out.println("Decoded=" + finalData);
		
		System.out.println("Decoded is equal to Original=" + (finalData.equals(sourceData)));
    }

	
	public static void testWithByteValueOfKeys() throws Throwable {
		//Generation of keys
		Pair<PublicKey,PrivateKey> keysValue = EncryptionRsaEcbPkcs1Padding.generateKeyPair();
		PublicKey publicKey = keysValue.getFirst();
		System.out.println("Public key =" + ((sun.security.rsa.RSAPublicKeyImpl)publicKey));
		PrivateKey privateKey = keysValue.getSecond();
		System.out.println("Private key =" + ((sun.security.rsa.RSAPrivateCrtKeyImpl)privateKey));

		// Data
		String sourceData = "123456ds fds #&er er "+System.getProperty("line.separator")+" ^rrr 7897ezrz";
		System.out.println("Original=" + sourceData);

		// Encrypt data
		byte[] encryptData = EncryptionRsaEcbPkcs1Padding.encrypt(publicKey.getEncoded(), sourceData.getBytes());
		System.out.println("Encoded=" + new String(encryptData));
		
		// Decrypt data
    	byte[] decryptData = EncryptionRsaEcbPkcs1Padding.decrypt(privateKey.getEncoded(), encryptData);
    	String finalData = (decryptData!=null)? new String(decryptData):"";
		System.out.println("Decoded=" + finalData);
		
		System.out.println("Decoded is equal to Original=" + (finalData.equals(sourceData)));
    }

	
	public static void testWithModulosExponentOfKeys() throws Throwable {
		//Generation of keys
		Pair<PublicKey,PrivateKey> keysValue = EncryptionRsaEcbPkcs1Padding.generateKeyPair();
		PublicKey publicKey = keysValue.getFirst();
		System.out.println("Public key =" + ((sun.security.rsa.RSAPublicKeyImpl)publicKey));
		PrivateKey privateKey = keysValue.getSecond();
		System.out.println("Private key =" + ((sun.security.rsa.RSAPrivateCrtKeyImpl)privateKey));

		// Get the modulus and Exponent of public and private keys
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        RSAPublicKeySpec rsaPubKeySpec = keyFactory.getKeySpec(publicKey, RSAPublicKeySpec.class);
        BigInteger modpublic = rsaPubKeySpec.getModulus(); // = ((RSAPublicKey)publicKey).getModulus());
        BigInteger exppublic = rsaPubKeySpec.getPublicExponent(); // = ((RSAPublicKey)publicKey).getPublicExponent());

        RSAPrivateKeySpec rsaPrivKeySpec = keyFactory.getKeySpec(privateKey, RSAPrivateKeySpec.class);
        BigInteger modprivate = rsaPrivKeySpec.getModulus(); // = ((RSAPrivateKey)privateKey).getModulus();
        BigInteger expprivate = rsaPrivKeySpec.getPrivateExponent(); // = ((RSAPrivateKey)privateKey).getPrivateExponent();

        System.out.println(" **** RSAPublicKey:");
        System.out.println(" Modulus public : " + modpublic);
        System.out.println(" Exponent public : " + exppublic);
		System.out.println(" **** RSAPrivateKey:");
        System.out.println(" Modulus private : " + modprivate);
        System.out.println(" Exponent private : " + expprivate);
		
		// Data
		String sourceData = "123456ds fds #&er er "+System.getProperty("line.separator")+" ^rrr 7897ezrz";
		System.out.println("Original=" + sourceData);

		// Encrypt data
		byte[] encryptData = EncryptionRsaEcbPkcs1Padding.encrypt(modpublic, exppublic, sourceData.getBytes());
		System.out.println("Encoded=" + new String(encryptData));
		
		// Decrypt data
    	byte[] decryptData = EncryptionRsaEcbPkcs1Padding.decrypt(modprivate, expprivate, encryptData);
    	String finalData = (decryptData!=null)? new String(decryptData):"";
		System.out.println("Decoded=" + finalData);
		
		System.out.println("Decoded is equal to Original=" + (finalData.equals(sourceData)));
    }
	
}
