package com.ho.crypto.test3.encryption.keystore;

import java.io.File;
import java.io.FileReader;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.spec.KeySpec;
import java.util.Date;
import java.util.Properties;

import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

import sun.security.x509.AlgorithmId;
import sun.security.x509.CertificateAlgorithmId;
import sun.security.x509.CertificateExtensions;
import sun.security.x509.CertificateIssuerName;
import sun.security.x509.CertificateSerialNumber;
import sun.security.x509.CertificateSubjectName;
import sun.security.x509.CertificateValidity;
import sun.security.x509.CertificateVersion;
import sun.security.x509.CertificateX509Key;
import sun.security.x509.KeyIdentifier;
import sun.security.x509.SubjectKeyIdentifierExtension;
import sun.security.x509.X500Name;
import sun.security.x509.X500Signer;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;

/**
 * Class Test of JCEKS Keystore Management
 * @author Huseyin OZVEREN
 */
public class KeyStoreManagementTest {

	public static void main(String[] args) {
		try{
	        Properties prop = getProperties();
	        // Generate the KeyStore
            KeyStoreManagement keyStoreManagement = new KeyStoreManagement(System.getProperty("user.dir") + "/resources/" + prop.getProperty("keystore_name"), prop.getProperty("keystore_pwd"));

            // ########################## SECRET KEY 1 : PBE-MD5-DES
            {
            	System.out.println("########################## SECRET KEY 1 : PBE-MD5-DES");
    	        // Generate a SecretKey
            	SecretKey secretKey = null;
                {
                	String encryptionType="PBEWithMD5AndDES";
                	KeySpec keySpec= new PBEKeySpec("HUO12JavDotLuX12".toCharArray());
                	secretKey = SecretKeyFactory.getInstance(encryptionType).generateSecret(keySpec);
                }

                // Add SecretKey to KeyStore
            	System.out.println("#### Add SecretKey to KeyStore : entry="+prop.getProperty("keystore_secretkey1_entry_name")+" and password="+prop.getProperty("keystore_secretkey1_entry_pwd"));
                keyStoreManagement.addSecretKey(prop.getProperty("keystore_secretkey1_entry_name"), prop.getProperty("keystore_secretkey1_entry_pwd"), secretKey);
    	        
                // Check the presence of SecretKey in KeyStore
            	System.out.println("#### Check the presence of SecretKey in KeyStore : entry="+prop.getProperty("keystore_secretkey1_entry_name")+" and password="+prop.getProperty("keystore_secretkey1_entry_pwd"));
                boolean isFound = keyStoreManagement.hasSecretKey(prop.getProperty("keystore_secretkey1_entry_name"), prop.getProperty("keystore_secretkey1_entry_pwd"), secretKey.getEncoded());
            	System.out.println("=>"+isFound);
    	        
            	// Get SecretKey from KeyStore
            	System.out.println("#### Get SecretKey from KeyStore : entry="+prop.getProperty("keystore_secretkey1_entry_name")+" and password="+prop.getProperty("keystore_secretkey1_entry_pwd"));
                SecretKey secretKeyExtract = keyStoreManagement.getSecretKey(prop.getProperty("keystore_secretkey1_entry_name"), prop.getProperty("keystore_secretkey1_entry_pwd"));
            	System.out.println("#### Check the value of original SecretKey and the extracted SecretKey : ");
            	System.out.println("=>"+new String(secretKeyExtract.getEncoded()).equals(new String(secretKey.getEncoded())));
            }

            // ########################## SECRET KEY 2 : AES 128 bytes
            {
            	System.out.println("########################## SECRET KEY 2 : AES 128 bytes");
    	        // Generate a SecretKey
            	SecretKey secretKey = null;
                {
                	KeyGenerator keyGenAes = KeyGenerator.getInstance("AES");
            		keyGenAes.init(128);
            		secretKey = keyGenAes.generateKey();
                }

                // Add SecretKey to KeyStore
            	System.out.println("#### Add SecretKey to KeyStore : entry="+prop.getProperty("keystore_secretkey2_entry_name")+" and password="+prop.getProperty("keystore_secretkey2_entry_pwd"));
                keyStoreManagement.addSecretKey(prop.getProperty("keystore_secretkey2_entry_name"), prop.getProperty("keystore_secretkey2_entry_pwd"), secretKey);
    	        
                // Check the presence of SecretKey in KeyStore
            	System.out.println("#### Check the presence of SecretKey in KeyStore : entry="+prop.getProperty("keystore_secretkey2_entry_name")+" and password="+prop.getProperty("keystore_secretkey2_entry_pwd"));
                boolean isFound = keyStoreManagement.hasSecretKey(prop.getProperty("keystore_secretkey2_entry_name"), prop.getProperty("keystore_secretkey2_entry_pwd"), secretKey.getEncoded());
            	System.out.println("=>"+isFound);
    	        
            	// Get SecretKey from KeyStore
            	System.out.println("#### Get SecretKey from KeyStore : entry="+prop.getProperty("keystore_secretkey2_entry_name")+" and password="+prop.getProperty("keystore_secretkey2_entry_pwd"));
                SecretKey secretKeyExtract = keyStoreManagement.getSecretKey(prop.getProperty("keystore_secretkey2_entry_name"), prop.getProperty("keystore_secretkey2_entry_pwd"));
            	System.out.println("#### Check the value of original SecretKey and the extracted SecretKey : ");
                System.out.println("=>"+new String(secretKeyExtract.getEncoded()).equals(new String(secretKey.getEncoded())));
            }
            

            // ########################## PRIVATE and PUBLIC KEY - RSA 1024
            {
            	System.out.println("########################## PRIVATE and PUBLIC KEY - RSA 1024");
    	        // Generate a PrivateKey and PublicKey
            	PrivateKey privateKey = null;
            	PublicKey publicKey = null;
            	X509Certificate certificate = null;
            	PublicKey publicKeyInCertificate = null;
                {
    	            // METHOD 1 : Use of JAVA classes
                	System.out.println("#### Generation of PrivateKey and PublicKey RSA 1024 via the use of JAVA classes");
        	   		KeyPairGenerator keyGenRsa = KeyPairGenerator.getInstance("RSA");
        	   		String signatureAlgorithm = "SHA1WithRSA";
        	   		keyGenRsa.initialize(1024);
        	   		KeyPair keyPair = keyGenRsa.genKeyPair();
        	   		publicKey = keyPair.getPublic();
        	   		privateKey = keyPair.getPrivate();
            		//Generate self signed certificate
                	System.out.println("#### Generation of self signed certificate with previous PrivateKey and PublicKey RSA 1024");
            		certificate = getSelfCertificate(new X500Name("CN=ROOT"), new Date(), (long)365*24*3600, signatureAlgorithm, privateKey, publicKey);
            		publicKeyInCertificate = certificate.getPublicKey();
    	            
    	            // METHOD 2 : Use of CertAndKeyGen class allowing the creation of self-signed X.509 certificates as well as PKCS 10 based certificate signing requests.
                	// Creates a CertAndKeyGen object for a particular key type, signature algorithm, and provider.
                	// 		o param keyType type of key, e.g. "RSA", "DSA"
                	// 		o param sigAlg name of the signature algorithm, e.g. "MD5WithRSA", "MD2WithRSA", "SHAwithDSA".
                	// 		o param providerName name of the provider
                	/*CertAndKeyGen keyGen=new CertAndKeyGen("RSA","SHA1WithRSA",null);
                	keyGen.generate(1024);
                	//Generate self signed certificate
                	publicKey = keyGen.getPublicKey();
                	privateKey = keyGen.getPrivateKey();
                	certificate = keyGen.getSelfCertificate(new X500Name("CN=ROOT"), (long)365*24*3600);
                	publicKeyInCertificate = certificate.getPublicKey();
                	System.out.println(new String(publicKey.getEncoded()).equals(new String(publicKeyInCertificate.getEncoded())));*/
                }
            	System.out.println("#### Check the value of original PublicKey and the PublicKey insided the Certificate: ");
                System.out.println("=>"+new String(publicKey.getEncoded()).equals(new String(publicKeyInCertificate.getEncoded())));

            	System.out.println("#### Creation of Certificate Chain with the previous Certificate");
                X509Certificate[] certificatesChain = new X509Certificate[1];
                certificatesChain[0]= certificate;

	            // Add PrivateKey to KeyStore
            	System.out.println("#### Add PrivateKey to KeyStore : entry="+prop.getProperty("keystore_privatekey_entry_name")+" and password="+prop.getProperty("keystore_privatekey_entry_pwd"));
	            keyStoreManagement.addPrivateKey(prop.getProperty("keystore_privatekey_entry_name"), prop.getProperty("keystore_privatekey_entry_pwd"), privateKey, certificatesChain);

	            // Add Certificate to KeyStore
	            // java.security.KeyStoreException: trusted certificate entries are not password-protected
            	System.out.println("#### Add Certificate to KeyStore : entry="+prop.getProperty("keystore_certificate_entry_name"));
	            keyStoreManagement.addCertificate(prop.getProperty("keystore_certificate_entry_name"), certificate);

	            // Check the presence of PrivateKey in KeyStore
            	System.out.println("#### Check the presence of PrivateKey in KeyStore : entry="+prop.getProperty("keystore_privatekey_entry_name")+" and password="+prop.getProperty("keystore_privatekey_entry_pwd"));
	            boolean isFound = keyStoreManagement.hasPrivateKey(prop.getProperty("keystore_privatekey_entry_name"), prop.getProperty("keystore_privatekey_entry_pwd"), privateKey.getEncoded());
	        	System.out.println("=>"+isFound);
		        
	        	// Get PrivateKey from KeyStore
            	System.out.println("#### Get PrivateKey from KeyStore : entry="+prop.getProperty("keystore_privatekey_entry_name")+" and password="+prop.getProperty("keystore_privatekey_entry_pwd"));
	        	PrivateKey privateKeyExtract = keyStoreManagement.getPrivateKey(prop.getProperty("keystore_privatekey_entry_name"), prop.getProperty("keystore_privatekey_entry_pwd"));
            	System.out.println("#### Check the value of original PrivateKey and the extracted PrivateKey : ");
	            System.out.println("=>"+new String(privateKeyExtract.getEncoded()).equals(new String(privateKey.getEncoded())));

	            // Check the presence of Certificate in KeyStore
            	System.out.println("#### Check the presence of Certificate in KeyStore : entry="+prop.getProperty("keystore_certificate_entry_name"));
	            isFound = keyStoreManagement.hasCertificate(prop.getProperty("keystore_certificate_entry_name"), certificate.getEncoded());
	        	System.out.println("=>"+isFound);
		        
	            // Check the presence of PublicKey in KeyStore
            	System.out.println("#### Check the presence of PublicKey in KeyStore : entry="+prop.getProperty("keystore_certificate_entry_name"));
	            isFound = keyStoreManagement.hasPublicKeyOfCertificate(prop.getProperty("keystore_certificate_entry_name"), publicKey.getEncoded());
	        	System.out.println("=>"+isFound);

	        	// Get Certificate from KeyStore
            	System.out.println("#### Get Certificate from KeyStore : entry="+prop.getProperty("keystore_certificate_entry_name"));
	        	Certificate certificateExtract = keyStoreManagement.getCertificate(prop.getProperty("keystore_certificate_entry_name"));
	        	System.out.println("#### Check the value of original Certificate and the extracted Certificate : ");
	            System.out.println("=>"+new String(certificateExtract.getEncoded()).equals(new String(certificate.getEncoded())));

	        	// Get PublicKey from KeyStore
            	System.out.println("#### Get PublicKey from KeyStore : entry="+prop.getProperty("keystore_certificate_entry_name"));
	        	PublicKey publicKeyExtract = keyStoreManagement.getPublicKeyOfCertificate(prop.getProperty("keystore_certificate_entry_name"));
	        	System.out.println("#### Check the value of original PublicKey and the extracted PublicKey : ");
	            System.out.println("=>"+new String(publicKeyExtract.getEncoded()).equals(new String(publicKey.getEncoded())));
            }

		}catch(Throwable th){
			th.printStackTrace();
		}
    }

    public static Properties getProperties() throws Exception {
        Properties prop = new Properties();
        String filename = System.getProperty("user.dir") + "/resources/ConfigKeystore.properties";
        prop.load(new FileReader(new File(filename).getPath()));
        return prop;
    }
    
    
    public static X509Certificate getSelfCertificate (X500Name myname, Date firstDate, long validity, String sigAlg, PrivateKey privateKey, PublicKey publicKey) throws Exception{
        X509CertImpl cert;
        //This class X500Signer has been created in our project in order to compensate the lack of used JDK/JRE. 
        X500Signer issuer = null;
        {
           	Signature signature = Signature.getInstance(sigAlg);
           	signature.initSign (privateKey);
           	issuer = new X500Signer (signature, myname);
        }

        Date lastDate = new Date ();
        lastDate.setTime (firstDate.getTime () + validity * 1000);

        CertificateValidity interval = new CertificateValidity(firstDate,lastDate);

        X509CertInfo info = new X509CertInfo();
        // Add all mandatory attributes
        info.set(X509CertInfo.VERSION, new CertificateVersion(CertificateVersion.V3));
        info.set(X509CertInfo.SERIAL_NUMBER, new CertificateSerialNumber((int)(firstDate.getTime()/1000)));
        AlgorithmId algID = issuer.getAlgorithmId();
        info.set(X509CertInfo.ALGORITHM_ID, new CertificateAlgorithmId(algID));
        info.set(X509CertInfo.SUBJECT, new CertificateSubjectName(myname));
        info.set(X509CertInfo.KEY, new CertificateX509Key(publicKey));
        info.set(X509CertInfo.VALIDITY, interval);
        info.set(X509CertInfo.ISSUER, new CertificateIssuerName(issuer.getSigner()));

        if (System.getProperty("sun.security.internal.keytool.skid") != null) {
        	CertificateExtensions ext = new CertificateExtensions();
            ext.set(SubjectKeyIdentifierExtension.NAME, new SubjectKeyIdentifierExtension(new KeyIdentifier(publicKey).getIdentifier()));
            info.set(X509CertInfo.EXTENSIONS, ext);
        }

        cert = new X509CertImpl(info);
        cert.sign(privateKey, sigAlg);
        return (X509Certificate)cert;
    }

}
